
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Bill
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bobby
    x2 = model.addVar(name="x2", lb=0)  # hours worked by John
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Jean

    # Objective function
    model.setObjective(1*x0 + 7*x1 + 7*x2 + 2*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6.03*x0 + 7.15*x1 >= 27)
    model.addConstr(3.18*x2 + 10.35*x3 >= 53)
    model.addConstr(6.03*x0 + 7.15*x1 + 10.35*x3 >= 49)
    model.addConstr(6.03*x0 + 7.15*x1 + 3.18*x2 + 10.35*x3 >= 49)
    model.addConstr(11.64*x1 + 4.78*x3 >= 30)
    model.addConstr(11.64*x1 + 9.03*x2 >= 20)
    model.addConstr(9.03*x2 + 4.78*x3 >= 31)
    model.addConstr(11.64*x1 + 9.03*x2 + 4.78*x3 >= 29)
    model.addConstr(9.43*x0 + 11.64*x1 + 9.03*x2 + 4.78*x3 >= 29)
    model.addConstr(7*x1 - x2 >= 0)
    model.addConstr(-7*x1 + 7*x3 >= 0)
    model.addConstr(4*x0 - 10*x3 >= 0)
    model.addConstr(6.03*x0 + 7.15*x1 + 3.18*x2 <= 212)
    model.addConstr(9.43*x0 + 9.03*x2 + 4.78*x3 <= 152)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Bill: ", x0.varValue)
        print("Hours worked by Bobby: ", x1.varValue)
        print("Hours worked by John: ", x2.varValue)
        print("Hours worked by Jean: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
