
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, vtype=gp.GRB.INTEGER, name=["hole_punches", "usb_flash_drives", "color_printers", "cans_of_coffee", "office_chairs", "smoke_detectors"])


# Set objective function
m.setObjective(8.08 * x[0] + 9.17 * x[1] + 4.76 * x[2] + 3.89 * x[3] + 6.11 * x[4] + 7.68 * x[5], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * x[0] + 6 * x[1] + 10 * x[2] + 10 * x[3] + 9 * x[4] + 5 * x[5] <= 174, "r0")
m.addConstr(8 * x[0] + 9 * x[1] + 1 * x[2] + 9 * x[3] + 5 * x[4] + 10 * x[5] <= 403, "r1")

# ... (rest of the constraints from the JSON "constraints" field)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for i in range(6):
        print(f"{x[i].varName}: {x[i].x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

