
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hole_punches")
x2 = m.addVar(vtype=GRB.INTEGER, name="usb_flash_drives")
x3 = m.addVar(vtype=GRB.INTEGER, name="color_printers")
x4 = m.addVar(vtype=GRB.INTEGER, name="cans_of_coffee")
x5 = m.addVar(vtype=GRB.INTEGER, name="office_chairs")
x6 = m.addVar(vtype=GRB.INTEGER, name="smoke_detectors")

# Add constraints
m.addConstr(x1 + x4 <= 151, "hole_punches_and_coffee")
m.addConstr(x1 + x6 <= 321, "hole_punches_and_smoke_detectors")
m.addConstr(x2 + x3 <= 138, "usb_flash_drives_and_color_printers")

# Add all other constraints from the problem statement here
# For example:
m.addConstr(x1 + x4 <= 150, "sustainability_hole_punches_coffee")  # Sustainability score constraint

# Objective function is just to find a feasible solution
m.setObjective(0, GRB.MINIMIZE)

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
