
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(name="milligrams_of_magnesium")
    x1 = m.addVar(name="milligrams_of_vitamin_B3")


    # Set objective function
    m.setObjective(5.17*x0**2 + 2.62*x0*x1 + 5.21*x1**2 + 6.16*x0 + 4.47*x1, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(17*x0 + 10*x1 >= 102, "c0")
    m.addConstr(23*x0 + 5*x1 >= 27, "c1")
    m.addConstr(4*x0 - 2*x1 >= 0, "c2")
    m.addConstr(17*x0 + 10*x1 <= 177, "c3")
    m.addConstr(23*x0 + 5*x1 <= 136, "c4")



    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

