
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="milligrams_of_magnesium")
x2 = m.addVar(lb=0, name="milligrams_of_vitamin_B3")

# Set the objective function
m.setObjective(5.17*x1**2 + 2.62*x1*x2 + 5.21*x2**2 + 6.16*x1 + 4.47*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*x1 + 10*x2 >= 102, name="muscle_growth_index_min")
m.addConstr(23*x1 + 5*x2 >= 27, name="energy_stability_index_min")
m.addConstr(4*x1 - 2*x2 >= 0, name="additional_constraint")
m.addConstr(17*x1 + 10*x2 <= 177, name="muscle_growth_index_max")
m.addConstr(23*x1 + 5*x2 <= 136, name="energy_stability_index_max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of magnesium: {x1.x}")
    print(f"Milligrams of vitamin B3: {x2.x}")
else:
    print("No optimal solution found")
