
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="milligrams_of_magnesium", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = model.addVar(name="milligrams_of_vitamin_B3", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Define the objective function
model.setObjective(5.17*x1**2 + 2.62*x1*x2 + 5.21*x2**2 + 6.16*x1 + 4.47*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(17*x1 + 10*x2 >= 102)
model.addConstr(23*x1 + 5*x2 >= 27)
model.addConstr(4*x1 - 2*x2 >= 0)
model.addConstr(17*x1 + 10*x2 <= 177)
model.addConstr(23*x1 + 5*x2 <= 136)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of magnesium: {x1.varValue}")
    print(f"Milligrams of vitamin B3: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
