
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(name="bowls of pasta")  # bowls of pasta
    x1 = m.addVar(name="steaks")  # steaks
    x2 = m.addVar(name="blueberry pies")  # blueberry pies


    # Set objective function
    m.setObjective(1*x0 + 5*x1 + 1*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2.81*x1 + 2.51*x2 >= 65, "c0")
    m.addConstr(1.58*x0 + 2.81*x1 + 2.51*x2 >= 65, "c1")
    m.addConstr(1.4*x0 + 3.08*x2 >= 54, "c2")
    m.addConstr(1.4*x0 + 3.27*x1 >= 106, "c3")
    m.addConstr(1.4*x0 + 3.27*x1 + 3.08*x2 >= 138, "c4")
    m.addConstr(2.85*x0 + 3.51*x1 >= 124, "c5")
    m.addConstr(2.85*x0 + 3.13*x2 >= 118, "c6")
    m.addConstr(3.51*x1 + 3.13*x2 >= 135, "c7")
    m.addConstr(2.85*x0 + 3.51*x1 + 3.13*x2 >= 135, "c8")
    m.addConstr(3.9*x0 + 3.81*x2 >= 53, "c9")
    m.addConstr(3.9*x0 + 2.12*x1 + 3.81*x2 >= 48, "c10")
    m.addConstr(0.73*x0 + 2.71*x1 + 1.78*x2 >= 75, "c11")
    m.addConstr(2*x0 - 2*x1 >= 0, "c12")
    m.addConstr(1.58*x0 + 2.81*x1 <= 370, "c13")
    m.addConstr(2.12*x1 + 3.81*x2 <= 127, "c14")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Problem is infeasible.')
    else:
        print('Problem could not be solved to optimality.')

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
