
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="bowls_of_pasta", lb=-gurobi.GRB.INFINITY)
x1 = model.addVar(name="steaks", lb=-gurobi.GRB.INFINITY)
x2 = model.addVar(name="blueberry_pies", lb=-gurobi.GRB.INFINITY)

# Set the objective function
model.setObjective(1 * x0 + 5 * x1 + 1 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(2.81 * x1 + 2.51 * x2 >= 65)
model.addConstr(1.58 * x0 + 2.81 * x1 + 2.51 * x2 >= 65)
model.addConstr(1.4 * x0 + 3.08 * x2 >= 54)
model.addConstr(1.4 * x0 + 3.27 * x1 >= 106)
model.addConstr(1.4 * x0 + 3.27 * x1 + 3.08 * x2 >= 138)
model.addConstr(1.4 * x0 + 3.51 * x1 >= 124)
model.addConstr(1.4 * x0 + 3.13 * x2 >= 118)
model.addConstr(3.51 * x1 + 3.13 * x2 >= 135)
model.addConstr(2.85 * x0 + 3.51 * x1 + 3.13 * x2 >= 135)
model.addConstr(3.9 * x0 + 3.81 * x2 >= 53)
model.addConstr(3.9 * x0 + 2.12 * x1 + 3.81 * x2 >= 48)
model.addConstr(2.71 * x1 + 1.78 * x2 >= 75)
model.addConstr(0.73 * x0 + 2.71 * x1 + 1.78 * x2 >= 75)
model.addConstr(2 * x0 - 2 * x1 >= 0)
model.addConstr(1.58 * x0 + 2.81 * x1 <= 370)
model.addConstr(2.12 * x1 + 3.81 * x2 <= 127)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("bowls of pasta: ", x0.varValue)
    print("steaks: ", x1.varValue)
    print("blueberry pies: ", x2.varValue)
else:
    print("The model is infeasible")
