
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    carbohydrates = m.addVar(name="carbohydrates")
    vitamin_a = m.addVar(name="vitamin_a")
    vitamin_b3 = m.addVar(name="vitamin_b3")
    potassium = m.addVar(name="potassium")
    magnesium = m.addVar(name="magnesium")


    # Set objective function
    m.setObjective(8.89 * carbohydrates + 1.58 * vitamin_a + 5.34 * vitamin_b3 + 4.52 * potassium + 6.46 * magnesium, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(24 * carbohydrates + 10 * vitamin_a + 7 * vitamin_b3 + 18 * potassium + 6 * magnesium <= 482, "digestive_support_index")
    m.addConstr(24 * carbohydrates + 18 * potassium >= 96, "c1")
    m.addConstr(7 * vitamin_b3 + 18 * potassium >= 83, "c2")
    m.addConstr(24 * carbohydrates + 10 * vitamin_a >= 80, "c3")
    m.addConstr(18 * potassium + 6 * magnesium >= 96, "c4")
    m.addConstr(7 * vitamin_b3 + 18 * potassium + 6 * magnesium >= 94, "c5")
    m.addConstr(24 * carbohydrates + 10 * vitamin_a + 6 * magnesium >= 94, "c6")
    m.addConstr(10 * vitamin_a + 18 * potassium + 6 * magnesium >= 94, "c7")
    m.addConstr(7 * vitamin_b3 + 18 * potassium + 6 * magnesium >= 78, "c8")
    m.addConstr(24 * carbohydrates + 10 * vitamin_a + 6 * magnesium >= 78, "c9")
    m.addConstr(10 * vitamin_a + 18 * potassium + 6 * magnesium >= 78, "c10")
    m.addConstr(7 * vitamin_b3 + 18 * potassium + 6 * magnesium >= 59, "c11")
    m.addConstr(24 * carbohydrates + 10 * vitamin_a + 6 * magnesium >= 59, "c12")
    m.addConstr(10 * vitamin_a + 18 * potassium + 6 * magnesium >= 59, "c13")
    m.addConstr(24 * carbohydrates + 10 * vitamin_a + 7 * vitamin_b3 + 18 * potassium + 6 * magnesium >= 59, "c14")
    m.addConstr(5 * vitamin_b3 - 3 * magnesium >= 0, "c15")
    m.addConstr(8 * carbohydrates - 5 * magnesium >= 0, "c16")
    m.addConstr(24 * carbohydrates + 18 * potassium <= 179, "c17")
    m.addConstr(10 * vitamin_a + 7 * vitamin_b3 <= 133, "c18")
    m.addConstr(7 * vitamin_b3 + 18 * potassium <= 409, "c19")
    m.addConstr(24 * carbohydrates + 10 * vitamin_a + 6 * magnesium <= 461, "c20")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
