
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # grams of carbohydrates
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin A
    x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin B3
    x4 = model.addVar(name="x4", lb=0)  # milligrams of potassium
    x5 = model.addVar(name="x5", lb=0)  # milligrams of magnesium

    # Objective function
    model.setObjective(8.89 * x1 + 1.58 * x2 + 5.34 * x3 + 4.52 * x4 + 6.46 * x5, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(24 * x1 <= 482)
    model.addConstr(10 * x2 <= 482)
    model.addConstr(7 * x3 <= 482)
    model.addConstr(18 * x4 <= 482)
    model.addConstr(6 * x5 <= 482)

    model.addConstr(24 * x1 + 18 * x4 >= 96)
    model.addConstr(7 * x3 + 18 * x4 >= 83)
    model.addConstr(24 * x1 + 10 * x2 >= 80)
    model.addConstr(18 * x4 + 6 * x5 >= 96)
    model.addConstr(7 * x3 + 18 * x4 + 6 * x5 >= 94)
    model.addConstr(24 * x1 + 10 * x2 + 6 * x5 >= 94)
    model.addConstr(10 * x2 + 18 * x4 + 6 * x5 >= 94)
    model.addConstr(7 * x3 + 18 * x4 + 6 * x5 >= 78)
    model.addConstr(24 * x1 + 10 * x2 + 6 * x5 >= 78)
    model.addConstr(10 * x2 + 18 * x4 + 6 * x5 >= 78)
    model.addConstr(7 * x3 + 18 * x4 + 6 * x5 >= 59)
    model.addConstr(24 * x1 + 10 * x2 + 6 * x5 >= 59)
    model.addConstr(10 * x2 + 18 * x4 + 6 * x5 >= 59)
    model.addConstr(24 * x1 + 10 * x2 + 7 * x3 + 18 * x4 + 6 * x5 >= 59)

    model.addConstr(5 * x3 - 3 * x5 >= 0)
    model.addConstr(8 * x1 - 5 * x5 >= 0)

    model.addConstr(24 * x1 + 18 * x4 <= 179)
    model.addConstr(10 * x2 + 7 * x3 <= 133)
    model.addConstr(7 * x3 + 18 * x4 <= 409)
    model.addConstr(24 * x1 + 10 * x2 + 6 * x5 <= 461)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"x4: {x4.varValue}")
        print(f"x5: {x5.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
