
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="grams_of_fiber")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="milligrams_of_vitamin_B4")
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milligrams_of_vitamin_B7")
x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milligrams_of_vitamin_C")
x4 = m.addVar(vtype=gp.GRB.INTEGER, name="grams_of_protein")
x5 = m.addVar(vtype=gp.GRB.INTEGER, name="milligrams_of_vitamin_B12")


# Set objective function
m.setObjective(x0**2 + x0*x1 + 9*x0*x2 + 7*x0*x3 + 6*x0*x4 + 2*x0*x5 + 5*x1**2 + 8*x1*x2 + 5*x1*x3 + 9*x1*x5 + 7*x2**2 + 7*x2*x3 + 8*x2*x4 + 7*x2*x5 + 9*x3**2 + 3*x3*x4 + 4*x3*x5 + 4*x4**2 + 4*x4*x5 + 9*x5**2 + 8*x0 + 7*x1 + 9*x2 + 3*x3 + x4 + 9*x5, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(30*x0 + 18*x1 + 21*x2 + 20*x3 + 26*x4 + 22*x5 <= 501, "r0")
m.addConstr(18*x1 + 20*x3 >= 42, "c1")
m.addConstr(30*x0**2 + 21*x2**2 >= 72, "c2")
m.addConstr(30*x0 + 18*x1 >= 51, "c3")
m.addConstr(18*x1 + 22*x5 >= 29, "c4")
m.addConstr(26*x4**2 + 22*x5**2 >= 49, "c5")
m.addConstr(20*x3**2 + 22*x5**2 >= 68, "c6")
m.addConstr(18*x1**2 + 21*x2**2 >= 35, "c7")
m.addConstr(21*x2**2 + 22*x5**2 >= 42, "c8")
m.addConstr(30*x0 + 20*x3 >= 31, "c9")
m.addConstr(21*x2 + 26*x4 + 22*x5 >= 68, "c10")
m.addConstr(30*x0 + 21*x2 + 26*x4 >= 68, "c11")
m.addConstr(30*x0**2 + 21*x2**2 + 20*x3**2 >= 68, "c12")
m.addConstr(18*x1**2 + 20*x3**2 + 22*x5**2 >= 68, "c13")
m.addConstr(21*x2 + 20*x3 + 22*x5 >= 68, "c14")
m.addConstr(21*x2**2 + 26*x4**2 + 22*x5**2 >= 55, "c15")
m.addConstr(30*x0 + 21*x2 + 26*x4 >= 55, "c16")
m.addConstr(30*x0 + 21*x2 + 20*x3 >= 55, "c17")
m.addConstr(18*x1 + 20*x3 + 22*x5 >= 55, "c18")
m.addConstr(21*x2 + 20*x3 + 22*x5 >= 55, "c19")
m.addConstr(21*x2 + 26*x4 + 22*x5 >= 42, "c20")
m.addConstr(30*x0 + 21*x2 + 26*x4 >= 42, "c21")
m.addConstr(30*x0**2 + 21*x2**2 + 20*x3**2 >= 42, "c22")
m.addConstr(18*x1**2 + 20*x3**2 + 22*x5**2 >= 42, "c23")
m.addConstr(21*x2**2 + 20*x3**2 + 22*x5**2 >= 42, "c24")
m.addConstr(21*x2**2 + 26*x4**2 + 22*x5**2 >= 57, "c25")
m.addConstr(30*x0**2 + 21*x2**2 + 26*x4**2 >= 57, "c26")
m.addConstr(30*x0**2 + 21*x2**2 + 20*x3**2 >= 57, "c27")
m.addConstr(18*x1 + 20*x3 + 22*x5 >= 57, "c28")
m.addConstr(21*x2 + 20*x3 + 22*x5 >= 57, "c29")
m.addConstr(21*x2 + 26*x4 + 22*x5 >= 69, "c30")
m.addConstr(30*x0 + 21*x2 + 26*x4 >= 69, "c31")
m.addConstr(30*x0 + 21*x2 + 20*x3 >= 69, "c32")
m.addConstr(18*x1 + 20*x3 + 22*x5 >= 69, "c33")
m.addConstr(21*x2 + 20*x3 + 22*x5 >= 69, "c34")
m.addConstr(30*x0 + 18*x1 + 21*x2 + 20*x3 + 26*x4 + 22*x5 >= 69, "c35")
m.addConstr(-9*x1 + 5*x5 >= 0, "c36")
m.addConstr(2*x2**2 - 7*x4**2 >= 0, "c37")
m.addConstr(18*x1 + 21*x2 <= 196, "c38")
m.addConstr(30*x0 + 21*x2 <= 463, "c39")
m.addConstr(18*x1 + 26*x4 <= 442, "c40")
m.addConstr(30*x0**2 + 18*x1**2 <= 362, "c41")
m.addConstr(30*x0**2 + 21*x2**2 + 20*x3**2 <= 234, "c42")
m.addConstr(21*x2 + 20*x3 + 22*x5 <= 297, "c43")
m.addConstr(18*x1 + 21*x2 + 26*x4 <= 277, "c44")
m.addConstr(21*x2**2 + 26*x4**2 + 22*x5**2 <= 382, "c45")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

