
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bobby_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby_hours")
john_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john_hours")
ringo_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ringo_hours")
laura_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="laura_hours")
jean_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean_hours")


# Set objective function
m.setObjective(7.84*bobby_hours**2 + 2.19*bobby_hours*john_hours + 3.28*bobby_hours*ringo_hours + 6.15*bobby_hours*laura_hours + 7.03*bobby_hours*jean_hours + 6.23*john_hours*ringo_hours + 8.13*ringo_hours*laura_hours + 6.08*ringo_hours*jean_hours + 2.24*laura_hours**2 + 9.77*laura_hours*jean_hours + 3.49*jean_hours**2 + 5.9*bobby_hours + 6.74*john_hours + 3.8*ringo_hours + 5.52*laura_hours + 2.44*jean_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8*ringo_hours + 9*laura_hours >= 27)
m.addConstr(12*john_hours + 8*ringo_hours >= 29)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Bobby Hours:', bobby_hours.x)
    print('John Hours:', john_hours.x)
    print('Ringo Hours:', ringo_hours.x)
    print('Laura Hours:', laura_hours.x)
    print('Jean Hours:', jean_hours.x)

elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

