
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(lb=0, name="x0")
x1 = m.addVar(lb=0, name="x1")
x2 = m.addVar(lb=0, name="x2", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(lb=0, name="x3", vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(lb=0, name="x4", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(7.84*x0**2 + 2.19*x0*x1 + 3.28*x0*x2 + 6.15*x0*x3 + 7.03*x0*x4 + 
               6.23*x1*x2 + 8.13*x2*x3 + 6.08*x2*x4 + 2.24*x3**2 + 9.77*x3*x4 + 
               3.49*x4**2 + 5.9*x0 + 6.74*x1 + 3.8*x2 + 5.52*x3 + 2.44*x4, 
               gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(14*x0 >= 14)
m.addConstr(19*x0 >= 19)
m.addConstr(20*x0 >= 20)
m.addConstr(14*x0 >= 14)
m.addConstr(12*x1 >= 12)
m.addConstr(12*x1 >= 12)
m.addConstr(12*x1 >= 12)
m.addConstr(7*x1 >= 7)
m.addConstr(8*x2 >= 8)
m.addConstr(2*x2 >= 2)
m.addConstr(12*x2 >= 12)
m.addConstr(12*x2 >= 12)
m.addConstr(9*x3 >= 9)
m.addConstr(8*x3 >= 8)
m.addConstr(19*x3 >= 19)
m.addConstr(19*x3 >= 19)
m.addConstr(10*x4 >= 10)
m.addConstr(20*x4 >= 20)
m.addConstr(4*x4 >= 4)
m.addConstr(7*x4 >= 7)
m.addConstr(8*x2 + 9*x3 >= 27)
m.addConstr(12*x1 + 8*x2 >= 29)
m.addConstr(14**2*x0**2 + 12**2*x1**2 + 9**2*x3**2 >= 39)
m.addConstr(14*x0 + 12*x1 + 8*x2 >= 39)
m.addConstr(14*x0 + 8*x2 + 9*x3 >= 39)
m.addConstr(14**2*x0**2 + 8**2*x2**2 + 10**2*x4**2 >= 39)
m.addConstr(12**2*x1**2 + 8**2*x2**2 + 10**2*x4**2 >= 39)
m.addConstr(14**2*x0**2 + 12**2*x1**2 + 9**2*x3**2 >= 51)
m.addConstr(14**2*x0**2 + 12**2*x1**2 + 8**2*x2**2 >= 51)
m.addConstr(14*x0 + 8*x2 + 9*x3 >= 51)
m.addConstr(14*x0 + 8*x2 + 10*x4 >= 51)
m.addConstr(12*x1 + 8*x2 + 10*x4 >= 51)
m.addConstr(14*x0 + 12*x1 + 9*x3 >= 38)
m.addConstr(14*x0 + 12*x1 + 8*x2 >= 38)
m.addConstr(14**2*x0**2 + 8**2*x2**2 + 9**2*x3**2 >= 38)
m.addConstr(14*x0 + 8*x2 + 10*x4 >= 38)
m.addConstr(12*x1 + 8*x2 + 10*x4 >= 38)
m.addConstr(14*x0 + 12*x1 + 9*x3 >= 54)
m.addConstr(14*x0 + 12*x1 + 8*x2 >= 54)
m.addConstr(14*x0 + 8*x2 + 9*x3 >= 54)
m.addConstr(14**2*x0**2 + 8**2*x2**2 + 10**2*x4**2 >= 54)
m.addConstr(12*x1 + 8*x2 + 10*x4 >= 54)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("No solution found")
