
import gurobipy as gp

# Create a new model
m = gp.Model("cybersecurity_optimization")

# Create variables
x = m.addVars(7, names=['pen testers', 'honeypots', 'system administrators', 'patches per day', 'automatic alerts', 'SOC operators', 'security onions'], type=gp.GRB.INTEGER)


# Set objective function
m.setObjective(3*x[0] + 7*x[1] + 3*x[2] + 7*x[3] + 4*x[4] + 1*x[5] + 1*x[6], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x[0] + 7*x[1] + 18*x[2] + 16*x[3] + 4*x[4] + 11*x[5] + 14*x[6] <= 225, "r0")

impact_values = [3, 7, 18, 16, 4, 11, 14]
constraint_combinations = [
    ([0, 3, 6], [20, 23, 28, 32, 30, 19, 17, 27, 22]),
    ([1, 2, 5], [20, 23, 28, 32, 30, 19, 17, 27, 22]),
    ([1, 3, 4], [20, 23, 28, 32, 30, 19, 17, 27, 22]),
    ([0, 2, 4], [20, 23, 28, 32, 30, 19, 17, 27, 22]),
    ([0, 4, 5], [20, 23, 28, 32, 30, 19, 17, 27, 22]),
    ([3, 4, 5], [20, 23, 28, 32, 30, 19, 17, 27, 22]),
    ([3, 5, 6], [20, 23, 28, 32, 30, 19, 17, 27, 22]),
    ([1, 2, 6], [20, 23, 28, 32, 30, 19, 17, 27, 22]),
    ([0, 1, 2], [20, 23, 28, 32, 30, 19, 17, 27, 22]),
    ([2, 3, 6], [20, 23, 28, 32, 30, 19, 17, 27, 22]),
    ([0, 2, 6], [20, 23, 28, 32, 30, 19, 17, 27, 22]),
    ([0, 5, 6], [20, 23, 28, 32, 30, 19, 17, 27, 22])
]

for combination, bounds in constraint_combinations:
    for bound in bounds:
        constraint = gp.LinExpr()
        for var_index in combination:
            constraint += impact_values[var_index] * x[var_index]
        m.addConstr(constraint >= bound)

m.addConstr(16*x[3] + 14*x[6] <= 86)
m.addConstr(7*x[1] + 11*x[5] <= 78)
m.addConstr(7*x[1] + 14*x[6] <= 198)
m.addConstr(4*x[4] + 11*x[5] <= 199)
m.addConstr(3*x[0] + 16*x[3] <= 176)
m.addConstr(3*x[0] + 18*x[2] <= 140)
m.addConstr(18*x[2] + 4*x[4] <= 188)
m.addConstr(7*x[1] + 18*x[2] <= 195)
m.addConstr(18*x[2] + 16*x[3] + 4*x[4] <= 62)
m.addConstr(3*x[0] + 18*x[2] + 11*x[5] <= 97)
m.addConstr(3*x[0] + 16*x[3] + 14*x[6] <= 168)
m.addConstr(3*x[0] + 11*x[5] + 14*x[6] <= 55)
m.addConstr(18*x[2] + 11*x[5] + 14*x[6] <= 101)
m.addConstr(16*x[3] + 4*x[4] + 11*x[5] <= 82)
m.addConstr(3*x[0] + 7*x[1] + 18*x[2] + 16*x[3] + 4*x[4] + 11*x[5] + 14*x[6] <= 82)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Obj: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {m.status}")

