
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("minimize_cost")

    # Create variables
    x = {}
    x[0] = model.addVar(vtype=GRB.INTEGER, name="Jean")
    x[1] = model.addVar(vtype=GRB.INTEGER, name="John")
    x[2] = model.addVar(vtype=GRB.INTEGER, name="Peggy")
    x[3] = model.addVar(vtype=GRB.CONTINUOUS, name="George")
    x[4] = model.addVar(vtype=GRB.CONTINUOUS, name="Mary")


    # Set objective function
    model.setObjective(5*x[0] + 3*x[1] + 3*x[2] + 2*x[3] + 6*x[4], GRB.MINIMIZE)

    # Add constraints
    model.addConstr(16*x[1] + 17*x[2] >= 56, "c1")
    model.addConstr(22*x[0] + 17*x[2] >= 33, "c2")
    model.addConstr(17*x[2] + 23*x[4] >= 55, "c3")
    model.addConstr(22*x[0] + 16*x[1] + 17*x[2] >= 51, "c4")
    model.addConstr(22*x[0] + 16*x[1] + 17*x[2] + 2*x[3] + 23*x[4] >= 51, "c5")
    model.addConstr(-2*x[0] + 8*x[4] >= 0, "c6")
    model.addConstr(16*x[1] + 2*x[3] <= 254, "c7")
    model.addConstr(16*x[1] + 17*x[2] <= 96, "c8")
    model.addConstr(22*x[0] + 16*x[1] <= 170, "c9")
    model.addConstr(22*x[0] + 2*x[3] <= 94, "c10")
    model.addConstr(17*x[2] + 23*x[4] <= 87, "c11")
    model.addConstr(22*x[0] + 23*x[4] <= 202, "c12")
    model.addConstr(2*x[3] + 23*x[4] <= 62, "c13")
    model.addConstr(17*x[2] + 2*x[3] <= 244, "c14")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % model.objVal)

    elif model.status == GRB.INFEASIBLE:
        print('Model is infeasible')
        model.computeIIS()
        model.write("model.ilp")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
