
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Jean
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by John
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy
    x4 = model.addVar(name="x4")  # hours worked by George
    x5 = model.addVar(name="x5")  # hours worked by Mary

    # Objective function
    model.setObjective(5 * x1 + 3 * x2 + 3 * x3 + 2 * x4 + 6 * x5, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(16 * x2 + 17 * x3 >= 56)
    model.addConstr(22 * x1 + 17 * x3 >= 33)
    model.addConstr(17 * x3 + 23 * x5 >= 55)
    model.addConstr(22 * x1 + 16 * x2 + 17 * x3 >= 51)
    model.addConstr(22 * x1 + 16 * x2 + 17 * x3 + 2 * x4 + 23 * x5 >= 51)
    model.addConstr(-2 * x1 + 8 * x5 >= 0)
    model.addConstr(16 * x2 + 2 * x4 <= 254)
    model.addConstr(16 * x2 + 17 * x3 <= 96)
    model.addConstr(22 * x1 + 16 * x2 <= 170)
    model.addConstr(22 * x1 + 2 * x4 <= 94)
    model.addConstr(17 * x3 + 23 * x5 <= 87)
    model.addConstr(22 * x1 + 23 * x5 <= 202)
    model.addConstr(2 * x4 + 23 * x5 <= 62)
    model.addConstr(17 * x3 + 2 * x4 <= 244)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Jean: {x1.varValue}")
        print(f"Hours worked by John: {x2.varValue}")
        print(f"Hours worked by Peggy: {x3.varValue}")
        print(f"Hours worked by George: {x4.varValue}")
        print(f"Hours worked by Mary: {x5.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
