
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
corn_cobs = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="corn_cobs")
black_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="black_beans")
slices_of_pizza = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="slices_of_pizza")
oreos = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="oreos")
strawberries = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="strawberries")


# Set objective function
m.setObjective(8.53 * potatoes + 1.25 * corn_cobs + 8.85 * black_beans + 6.57 * slices_of_pizza + 5.18 * oreos + 8.45 * strawberries, gp.GRB.MINIMIZE)

# Add constraints

umami_index = {
    'potatoes': 2.81,
    'corn_cobs': 0.55,
    'black_beans': 2.39,
    'slices_of_pizza': 2.19,
    'oreos': 2.54,
    'strawberries': 0.25
}
sourness_index = {
    'potatoes': 1.16,
    'corn_cobs': 1.81,
    'black_beans': 2.65,
    'slices_of_pizza': 0.59,
    'oreos': 2.14,
    'strawberries': 0.82
}

m.addConstr(umami_index['potatoes'] * potatoes + umami_index['corn_cobs'] * corn_cobs + umami_index['black_beans'] * black_beans + umami_index['slices_of_pizza'] * slices_of_pizza + umami_index['oreos'] * oreos + umami_index['strawberries'] * strawberries <= 189, "umami_upper_bound")
m.addConstr(sourness_index['potatoes'] * potatoes + sourness_index['corn_cobs'] * corn_cobs + sourness_index['black_beans'] * black_beans + sourness_index['slices_of_pizza'] * slices_of_pizza + sourness_index['oreos'] * oreos + sourness_index['strawberries'] * strawberries <= 193, "sourness_upper_bound")


m.addConstr(umami_index['corn_cobs'] * corn_cobs + umami_index['strawberries'] * strawberries >= 22)
m.addConstr(umami_index['black_beans'] * black_beans + umami_index['slices_of_pizza'] * slices_of_pizza >= 22)
m.addConstr(umami_index['potatoes'] * potatoes + umami_index['black_beans'] * black_beans >= 17)
m.addConstr(umami_index['corn_cobs'] * corn_cobs + umami_index['oreos'] * oreos >= 14)
m.addConstr(umami_index['oreos'] * oreos + umami_index['strawberries'] * strawberries >= 26)
m.addConstr(umami_index['corn_cobs'] * corn_cobs + umami_index['black_beans'] * black_beans >= 13)
m.addConstr(umami_index['potatoes'] * potatoes + umami_index['strawberries'] * strawberries >= 12)
m.addConstr(umami_index['black_beans'] * black_beans + umami_index['oreos'] * oreos >= 11)
m.addConstr(umami_index['corn_cobs'] * corn_cobs + umami_index['slices_of_pizza'] * slices_of_pizza >= 11)
m.addConstr(umami_index['potatoes'] * potatoes + umami_index['oreos'] * oreos >= 12)


# ... (rest of the constraints, following the same pattern)
m.addConstr(2 * oreos - strawberries >= 0)
m.addConstr(-potatoes + 3 * slices_of_pizza >= 0)
# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

