
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="potatoes", lb=-float('inf'))
x1 = m.addVar(name="corn_cobs", lb=0, type=gurobi.GRB.INTEGER)
x2 = m.addVar(name="black_beans", lb=-float('inf'))
x3 = m.addVar(name="slices_of_pizza", lb=0, type=gurobi.GRB.INTEGER)
x4 = m.addVar(name="oreos", lb=0, type=gurobi.GRB.INTEGER)
x5 = m.addVar(name="strawberries", lb=0, type=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(8.53*x0 + 1.25*x1 + 8.85*x2 + 6.57*x3 + 5.18*x4 + 8.45*x5, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(2.81*x0 + 0.55*x1 + 2.39*x2 + 2.19*x3 + 2.54*x4 + 0.25*x5 <= 189)
m.addConstr(1.16*x0 + 1.81*x1 + 2.65*x2 + 0.59*x3 + 2.14*x4 + 0.82*x5 <= 193)
m.addConstr(0.55*x1 + 0.25*x5 >= 22)
m.addConstr(2.39*x2 + 2.19*x3 >= 22)
m.addConstr(2.81*x0 + 2.39*x2 >= 17)
m.addConstr(0.55*x1 + 2.54*x4 >= 14)
m.addConstr(2.54*x4 + 0.25*x5 >= 26)
m.addConstr(0.55*x1 + 2.39*x2 >= 13)
m.addConstr(2.81*x0 + 0.25*x5 >= 12)
m.addConstr(2.39*x2 + 0.59*x3 >= 11)
m.addConstr(0.55*x1 + 2.19*x3 >= 11)
m.addConstr(2.81*x0 + 2.54*x4 >= 12)
m.addConstr(2.81*x0 + 2.39*x2 + 2.54*x4 >= 29)
m.addConstr(2.81*x0 + 2.19*x3 + 0.25*x5 >= 29)
m.addConstr(2.39*x2 + 2.19*x3 + 2.54*x4 >= 29)
m.addConstr(2.39*x2 + 2.54*x4 + 0.25*x5 >= 29)
m.addConstr(0.55*x1 + 2.54*x4 >= 29)
m.addConstr(2.81*x0 + 0.55*x1 + 2.54*x4 >= 29)
m.addConstr(2.81*x0 + 2.54*x4 + 0.25*x5 >= 29)
m.addConstr(2.81*x0 + 0.55*x1 + 0.25*x5 >= 29)
m.addConstr(2.81*x0 + 2.39*x2 + 0.25*x5 >= 29)
m.addConstr(2.81*x0 + 2.19*x3 + 2.54*x4 >= 29)
m.addConstr(0.55*x1 + 2.19*x3 + 0.25*x5 >= 29)
m.addConstr(0.55*x1 + 2.19*x3 + 2.54*x4 >= 29)
m.addConstr(2.81*x0 + 0.55*x1 + 2.19*x3 >= 29)
m.addConstr(2.81*x0 + 2.39*x2 + 2.19*x3 >= 29)
m.addConstr(2.81*x0 + 0.55*x1 + 2.39*x2 >= 29)
m.addConstr(2.39*x2 + 2.19*x3 + 0.25*x5 >= 29)
m.addConstr(0.55*x1 + 2.19*x3 + 2.54*x4 >= 29)
m.addConstr(1.16*x0 + 2.14*x4 <= 87)
m.addConstr(1.16*x0 + 0.59*x3 <= 48)
m.addConstr(2.65*x2 + 2.14*x4 <= 162)
m.addConstr(1.16*x0 + 0.82*x5 <= 39)
m.addConstr(1.81*x1 + 2.14*x4 <= 163)
m.addConstr(2*x4 - x5 >= 0)
m.addConstr(-x0 + 3*x3 >= 0)
m.addConstr(2.81*x0 + 0.55*x1 + 2.54*x4 <= 177)
m.addConstr(0.55*x1 + 2.39*x2 + 0.25*x5 <= 165)
m.addConstr(0.55*x1 + 2.39*x2 + 2.54*x4 <= 121)
m.addConstr(2.39*x2 + 0.59*x3 + 2.54*x4 <= 121)
m.addConstr(2.81*x0 + 0.59*x3 + 2.54*x4 <= 151)
m.addConstr(2.65*x2 + 2.14*x4 <= 87)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Potatoes: ", x0.varValue)
    print("Corn Cobs: ", x1.varValue)
    print("Black Beans: ", x2.varValue)
    print("Slices of Pizza: ", x3.varValue)
    print("Oreos: ", x4.varValue)
    print("Strawberries: ", x5.varValue)
else:
    print("No solution found")
