
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("work_optimization")

# Create variables
paul_hours = m.addVar(vtype=GRB.INTEGER, name="paul_hours")
bobby_hours = m.addVar(vtype=GRB.INTEGER, name="bobby_hours")


# Set objective function
m.setObjective(6 * paul_hours + 6 * bobby_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * paul_hours + 14 * bobby_hours >= 21, "work_quality_min")
m.addConstr(9 * paul_hours - 5 * bobby_hours >= 0, "work_balance")
m.addConstr(6 * paul_hours + 14 * bobby_hours <= 74, "work_quality_max")



# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal solution found:")
    print(f"  Hours worked by Paul: {paul_hours.x}")
    print(f"  Hours worked by Bobby: {bobby_hours.x}")
    print(f"  Total cost: {m.objVal}")

