
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Paul")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bobby")

# Set objective function
m.setObjective(6*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x1 + 14*x2 >= 21, name="work_quality_rating_min")
m.addConstr(9*x1 - 5*x2 >= 0, name="hours_worked_constraint")
m.addConstr(6*x1 + 14*x2 <= 74, name="work_quality_rating_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {x1.x}")
    print(f"Hours worked by Bobby: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
