
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Paul", vtype=gp.GRB.INTEGER)  # Integer hours worked by Paul
x2 = m.addVar(name="hours_worked_by_Bobby", vtype=gp.GRB.INTEGER)  # Integer hours worked by Bobby

# Objective function: Minimize 6 * (x1 + x2)
m.setObjective(6 * (x1 + x2), gp.GRB.MINIMIZE)

# Constraints
m.addConstr(6 * x1 + 14 * x2 >= 21, name="combined_work_quality_rating_min")
m.addConstr(6 * x1 + 14 * x2 <= 74, name="combined_work_quality_rating_max")
m.addConstr(9 * x1 - 5 * x2 >= 0, name="work_hours_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Paul: {x1.varValue}")
    print(f"Hours worked by Bobby: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
