
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_resource_allocation")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="automatic_alerts")
    x1 = model.addVar(vtype=GRB.INTEGER, name="SOC_operators")


    # Set objective function
    model.setObjective(3.48*x0**2 + 9.91*x0*x1 + 4.33*x0, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6*x0 + 5*x1 <= 28, "network_integrity_impact_limit")
    model.addConstr(2*x0 + 10*x1 <= 73, "power_consumption_limit_initial")
    model.addConstr(x0**2 + x1**2 >= 13, "combined_network_impact_minimum")
    model.addConstr(2*x0 + 10*x1 >= 16, "power_consumption_minimum")
    model.addConstr(10*x0 - 8*x1 >= 0, "alerts_operators_ratio")
    model.addConstr(6*x0 + 5*x1 <= 14, "network_integrity_impact_limit_final")
    model.addConstr(2*x0 + 10*x1 <= 58, "power_consumption_limit_final")



    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Automatic Alerts: {x0.x}")
        print(f"SOC Operators: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
