
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts")
x1 = m.addVar(vtype=GRB.INTEGER, name="SOC_operators")

# Objective function: Maximize 3.48*x0^2 + 9.91*x0*x1 + 4.33*x0
m.setObjective(3.48 * x0**2 + 9.91 * x0 * x1 + 4.33 * x0, GRB.MAXIMIZE)

# Constraints
m.addConstr((6*x0)**2 + (5*x1)**2 >= 13, name="total_network_integrity")
m.addConstr(2*x0 + 10*x1 >= 16, name="min_power_consumption")
m.addConstr(10*x0 - 8*x1 >= 0, name="balance_constraint")
m.addConstr(6*x0 + 5*x1 <= 14, name="max_total_network_integrity")
m.addConstr(2*x0 + 10*x1 <= 58, name="max_power_consumption")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x0 = {x0.X}, x1 = {x1.X}")
else:
    print("No optimal solution found")
