
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="automatic_alerts", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="SOC_operators", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(3.48*x1**2 + 9.91*x1*x2 + 4.33*x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6*x1 + 5*x2 <= 14, name="network_integrity")
    model.addConstr(2*x1 + 10*x2 <= 58, name="power_consumption")
    model.addConstr(x1**2 + x2**2 >= 13, name="network_integrity_squared")
    model.addConstr(2*x1 + 10*x2 >= 16, name="power_consumption_contribution")
    model.addConstr(10*x1 - 8*x2 >= 0, name="alerts_vs_operators")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Automatic Alerts: {x1.varValue}")
        print(f"SOC Operators: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
