
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin B4
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # milligrams of magnesium


    # Set objective function
    m.setObjective(x0**2 + 9*x0*x1 + 2*x1**2 + 2*x1, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1*x0 + 4*x1 <= 53, "c0")
    m.addConstr(8*x0 + 3*x1 <= 21, "c1")
    m.addConstr(x0**2 + 4*x1**2 >= 15, "c2")
    m.addConstr(8*x0 + 3*x1 >= 5, "c3")
    m.addConstr(7*x0**2 - 3*x1**2 >= 0, "c4")
    m.addConstr(x0 + 4*x1 <= 35, "c5")
    m.addConstr(x0 + 4*x1 == 35, "c6")
    m.addConstr(8*x0**2 + 3*x1**2 <= 17, "c7")
    m.addConstr(8*x0 + 3*x1 <= 17, "c8")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
