
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # milligrams of vitamin B4
x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")  # milligrams of magnesium

# Objective function
model.setObjective(x1**2 + 9*x1*x2 + 2*x2**2 + 2*x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 == 1, name="c1")
model.addConstr(x1**2 + 16*x2**2 >= 15, name="c2")
model.addConstr(8*x1 + 3*x2 >= 5, name="c3")
model.addConstr(7*x1**2 - 3*x2**2 >= 0, name="c4")
model.addConstr(x1 + 4*x2 <= 35, name="c5")
model.addConstr(8*x1 + 3*x2 <= 17, name="c6")
model.addConstr(64*x1**2 + 9*x2**2 <= 17, name="c7")

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"x1: {x1.varValue}")
    print(f"x2: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
