
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x0")  # milligrams of vitamin B6
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x1")  # milligrams of vitamin B7
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x2")  # milligrams of magnesium
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x3")  # milligrams of calcium

    # Objective function
    model.setObjective(1.28*x0 + 6.28*x1 + 6.55*x2 + 5.43*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4*x1 + x3 >= 44)
    model.addConstr(28*x0 + 35*x2 >= 76)
    model.addConstr(4*x1 + 35*x2 + 31*x3 >= 54)
    model.addConstr(28*x0 + 4*x1 + 35*x2 >= 54)
    model.addConstr(28*x0 + 4*x1 + 31*x3 >= 54)
    model.addConstr(28*x0 + 35*x2 + 31*x3 >= 54)
    model.addConstr(4*x1 + 35*x2 + 31*x3 >= 70)
    model.addConstr(28*x0 + 4*x1 + 35*x2 >= 70)
    model.addConstr(28*x0 + 4*x1 + 31*x3 >= 70)
    model.addConstr(28*x0 + 35*x2 + 31*x3 >= 70)
    model.addConstr(4*x1 + 35*x2 + 31*x3 >= 67)
    model.addConstr(28*x0 + 4*x1 + 35*x2 >= 67)
    model.addConstr(28*x0 + 4*x1 + 31*x3 >= 67)
    model.addConstr(28*x0 + 35*x2 + 31*x3 >= 67)
    model.addConstr(11*x2 + 16*x3 >= 54)
    model.addConstr(4*x0 + 16*x3 >= 42)
    model.addConstr(4*x0 + 12*x1 >= 70)
    model.addConstr(4*x0 + 11*x2 >= 95)
    model.addConstr(4*x0 + 11*x2 + 16*x3 >= 80)
    model.addConstr(4*x0 + 12*x1 + 11*x2 >= 80)
    model.addConstr(4*x0 + 12*x1 + 16*x3 >= 80)
    model.addConstr(4*x0 + 11*x2 + 16*x3 >= 85)
    model.addConstr(4*x0 + 12*x1 + 11*x2 >= 85)
    model.addConstr(4*x0 + 12*x1 + 16*x3 >= 85)
    model.addConstr(4*x0 + 11*x2 + 16*x3 >= 58)
    model.addConstr(4*x0 + 12*x1 + 11*x2 >= 58)
    model.addConstr(4*x0 + 12*x1 + 16*x3 >= 58)
    model.addConstr(-9*x0 + 2*x3 >= 0)
    model.addConstr(4*x1 + 31*x3 <= 313)
    model.addConstr(4*x1 + 35*x2 <= 113)
    model.addConstr(28*x0 + 4*x1 + 31*x3 <= 180)
    model.addConstr(28*x0 + 4*x1 + 35*x2 + 31*x3 <= 180)
    model.addConstr(12*x1 + 16*x3 <= 226)
    model.addConstr(4*x0 + 11*x2 <= 302)
    model.addConstr(11*x2 + 16*x3 <= 371)
    model.addConstr(4*x0 + 12*x1 + 11*x2 + 16*x3 <= 371)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B6: {x0.varValue}")
        print(f"Milligrams of vitamin B7: {x1.varValue}")
        print(f"Milligrams of magnesium: {x2.varValue}")
        print(f"Milligrams of calcium: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
