
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="bagged_salads", lb=0)  # No upper bound
    x2 = model.addVar(name="steaks", lb=0)     # No upper bound
    x3 = model.addVar(name="knishes", lb=0)   # No upper bound
    x4 = model.addVar(name="cherry_pies", lb=0)  # No upper bound
    x5 = model.addVar(name="kiwis", lb=0)     # No upper bound

    # Objective function
    model.setObjective(2*x1 + 8*x2 + 5*x3 + 5*x4 + 5*x5, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20*x2 + 11*x3 >= 19)
    model.addConstr(5*x1 + 20*x2 >= 10)
    model.addConstr(11*x3 + 14*x4 >= 8)
    model.addConstr(5*x1 + 14*x4 >= 13)
    model.addConstr(5*x1 + 20*x5 >= 18)
    model.addConstr(5*x1 + 11*x3 + 14*x4 >= 14)
    model.addConstr(5*x1 + 20*x2 + 20*x5 >= 14)
    model.addConstr(5*x1 + 11*x3 + 14*x4 >= 17)
    model.addConstr(5*x1 + 20*x2 + 20*x5 >= 17)
    model.addConstr(5*x1 + 20*x2 + 11*x3 + 14*x4 + 20*x5 >= 17)
    model.addConstr(-10*x4 + 9*x5 >= 0)
    model.addConstr(8*x3 - 2*x5 >= 0)
    model.addConstr(5*x2 - 5*x4 >= 0)

    # Add budget constraint
    model.addConstr(5*x1 + 20*x2 + 11*x3 + 14*x4 + 20*x5 <= 131)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("bagged salads: ", x1.varValue)
        print("steaks: ", x2.varValue)
        print("knishes: ", x3.varValue)
        print("cherry pies: ", x4.varValue)
        print("kiwis: ", x5.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
