
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B1
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of iron
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin K


# Set objective function
m.setObjective(1.72*x0**2 + 6.87*x0*x1 + 3.8*x0*x2 + 1.32*x1**2 + 2.8*x1*x2 + 6.88*x2**2 + 4.73*x0 + 2.35*x1 + 7.32*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14*x0 + 5*x1 + 6*x2 <= 132, "kidney_support_index")
m.addConstr(14*x0**2 + 5*x1**2 >= 34, "combined_kidney_support_1")
m.addConstr(14*x0**2 + 6*x2**2 >= 25, "combined_kidney_support_2")
m.addConstr(x0 + x1 + x2 >= 25, "total_combined_kidney_support")
m.addConstr(6*x1 - 3*x2 >= 0, "iron_vitamin_k_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('x0: %g' % x0.x)
    print('x1: %g' % x1.x)
    print('x2: %g' % x2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

