
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B1
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # milligrams of iron
    x3 = model.addVar(name="x3", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin K

    # Objective function
    model.setObjective(1.72*x1**2 + 6.87*x1*x2 + 3.8*x1*x3 + 1.32*x2**2 + 2.8*x2*x3 + 6.88*x3**2 + 4.73*x1 + 2.35*x2 + 7.32*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(14*x1 + 5*x2 + 6*x3 <= 132)
    model.addConstr(196*x1**2 + 25*x2**2 >= 34)
    model.addConstr(196*x1**2 + 36*x3**2 >= 25)
    model.addConstr(14*x1 + 5*x2 + 6*x3 >= 25)
    model.addConstr(6*x2 - 3*x3 >= 0)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B1: {x1.varValue}")
        print(f"Milligrams of iron: {x2.varValue}")
        print(f"Milligrams of vitamin K: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
