
import gurobipy as gp

# Create a new model
m = gp.Model("plant_optimization")

# Create variables
hydrangeas = m.addVar(vtype=gp.GRB.INTEGER, name="hydrangeas")
geraniums = m.addVar(vtype=gp.GRB.INTEGER, name="geraniums")
bean_stalks = m.addVar(vtype=gp.GRB.INTEGER, name="bean_stalks")
verbenas = m.addVar(vtype=gp.GRB.INTEGER, name="verbenas")

# Set objective function
m.setObjective(8*hydrangeas + 7*geraniums + 6*bean_stalks + 6*verbenas, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11.64*hydrangeas + 18.0*geraniums >= 67)
m.addConstr(13.26*hydrangeas + 15.87*verbenas >= 38)
m.addConstr(2.51*bean_stalks + 15.87*verbenas >= 20)
m.addConstr(13.26*hydrangeas + 2.51*bean_stalks >= 17)
m.addConstr(8.37*geraniums + 2.51*bean_stalks + 15.87*verbenas >= 29)
m.addConstr(13.26*hydrangeas + 8.37*geraniums + 2.51*bean_stalks >= 29)
m.addConstr(13.26*hydrangeas + 2.51*bean_stalks + 15.87*verbenas >= 29)
m.addConstr(8.37*geraniums + 2.51*bean_stalks + 15.87*verbenas >= 27)
m.addConstr(13.26*hydrangeas + 8.37*geraniums + 2.51*bean_stalks >= 27)
m.addConstr(13.26*hydrangeas + 2.51*bean_stalks + 15.87*verbenas >= 27)
m.addConstr(8.37*geraniums + 2.51*bean_stalks + 15.87*verbenas >= 25)
m.addConstr(13.26*hydrangeas + 8.37*geraniums + 2.51*bean_stalks >= 25)
m.addConstr(13.26*hydrangeas + 2.51*bean_stalks + 15.87*verbenas >= 25)
m.addConstr(13.27*bean_stalks + 1.78*verbenas <= 241)
m.addConstr(11.64*hydrangeas + 18.0*geraniums <= 175)
m.addConstr(11.64*hydrangeas + 13.27*bean_stalks <= 179)
m.addConstr(11.64*hydrangeas + 1.78*verbenas <= 79)
m.addConstr(11.64*hydrangeas + 18.0*geraniums + 13.27*bean_stalks <= 93)
m.addConstr(11.64*hydrangeas + 13.27*bean_stalks + 1.78*verbenas <= 154)
m.addConstr(11.64*hydrangeas + 18.0*geraniums + 13.27*bean_stalks + 1.78*verbenas <= 154)
m.addConstr(13.26*hydrangeas + 15.87*verbenas <= 168)
m.addConstr(8.37*geraniums + 2.51*bean_stalks <= 52)
m.addConstr(2.51*bean_stalks + 15.87*verbenas <= 129)
m.addConstr(13.26*hydrangeas + 8.37*geraniums + 2.51*bean_stalks <= 92)
m.addConstr(13.26*hydrangeas + 2.51*bean_stalks + 15.87*verbenas <= 110)
m.addConstr(13.26*hydrangeas + 8.37*geraniums + 2.51*bean_stalks + 15.87*verbenas <= 110)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

