
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hydrangeas", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="geraniums", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="bean_stalks", vtype=gp.GRB.INTEGER)
x4 = m.addVar(name="verbenas", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(8*x1 + 7*x2 + 6*x3 + 6*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11.64*x1 + 18.0*x2 >= 67)
m.addConstr(13.26*x1 + 15.87*x4 >= 38)
m.addConstr(2.51*x3 + 15.87*x4 >= 20)
m.addConstr(13.26*x1 + 2.51*x3 >= 17)
m.addConstr(8.37*x2 + 2.51*x3 + 15.87*x4 >= 29)
m.addConstr(13.26*x1 + 8.37*x2 + 2.51*x3 >= 29)
m.addConstr(13.26*x1 + 2.51*x3 + 15.87*x4 >= 29)
m.addConstr(8.37*x2 + 2.51*x3 + 15.87*x4 >= 27)
m.addConstr(13.26*x1 + 8.37*x2 + 2.51*x3 >= 27)
m.addConstr(13.26*x1 + 2.51*x3 + 15.87*x4 >= 27)
m.addConstr(8.37*x2 + 2.51*x3 + 15.87*x4 >= 25)
m.addConstr(13.26*x1 + 8.37*x2 + 2.51*x3 >= 25)
m.addConstr(13.26*x1 + 2.51*x3 + 15.87*x4 >= 25)
m.addConstr(13.27*x3 + 1.78*x4 <= 241)
m.addConstr(11.64*x1 + 18.0*x2 <= 175)
m.addConstr(11.64*x1 + 13.27*x3 <= 179)
m.addConstr(11.64*x1 + 1.78*x4 <= 79)
m.addConstr(11.64*x1 + 18.0*x2 + 13.27*x3 <= 93)
m.addConstr(11.64*x1 + 13.27*x3 + 1.78*x4 <= 154)
m.addConstr(11.64*x1 + 18.0*x2 + 13.27*x3 + 1.78*x4 <= 154)
m.addConstr(13.26*x1 + 15.87*x4 <= 168)
m.addConstr(8.37*x2 + 2.51*x3 <= 52)
m.addConstr(2.51*x3 + 15.87*x4 <= 129)
m.addConstr(13.26*x1 + 8.37*x2 + 2.51*x3 <= 92)
m.addConstr(13.26*x1 + 2.51*x3 + 15.87*x4 <= 110)
m.addConstr(13.26*x1 + 8.37*x2 + 2.51*x3 + 15.87*x4 <= 110)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hydrangeas: ", x1.varValue)
    print("Geraniums: ", x2.varValue)
    print("Bean Stalks: ", x3.varValue)
    print("Verbenas: ", x4.varValue)
else:
    print("The model is infeasible")
