
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bacon")
pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pasta")
oranges = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
corn = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn")

# Set objective function
m.setObjective(4.79 * bacon + 6.54 * pasta + 7.91 * oranges + 1.18 * corn, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(25 * bacon + 25 * pasta >= 42, "iron_bacon_pasta")
m.addConstr(5 * oranges + 13 * corn >= 54, "iron_oranges_corn")
m.addConstr(25 * pasta + 13 * corn >= 46, "iron_pasta_corn")
m.addConstr(25 * bacon + 13 * corn >= 72, "iron_bacon_corn")
m.addConstr(25 * bacon + 25 * pasta + 5 * oranges + 13 * corn >= 72, "iron_total")

m.addConstr(22 * bacon + 15 * pasta >= 45, "fat_bacon_pasta")
m.addConstr(22 * bacon + 23 * oranges >= 26, "fat_bacon_oranges")
m.addConstr(15 * pasta + 18 * corn >= 36, "fat_pasta_corn")
m.addConstr(15 * pasta + 23 * oranges >= 34, "fat_pasta_oranges")
m.addConstr(22 * bacon + 18 * corn >= 57, "fat_bacon_corn")
m.addConstr(22 * bacon + 23 * oranges + 18 * corn >= 48, "fat_bacon_oranges_corn")
m.addConstr(22 * bacon + 15 * pasta + 23 * oranges >= 48, "fat_bacon_pasta_oranges")
m.addConstr(15 * pasta + 23 * oranges + 18 * corn >= 48, "fat_pasta_oranges_corn")
m.addConstr(22 * bacon + 23 * oranges + 18 * corn >= 66, "fat_bacon_oranges_corn2")
m.addConstr(22 * bacon + 15 * pasta + 23 * oranges >= 66, "fat_bacon_pasta_oranges2")
m.addConstr(15 * pasta + 23 * oranges + 18 * corn >= 66, "fat_pasta_oranges_corn2")
m.addConstr(22 * bacon + 23 * oranges + 18 * corn >= 70, "fat_bacon_oranges_corn3")
m.addConstr(22 * bacon + 15 * pasta + 23 * oranges >= 70, "fat_bacon_pasta_oranges3")
m.addConstr(15 * pasta + 23 * oranges + 18 * corn >= 70, "fat_pasta_oranges_corn3")
m.addConstr(22 * bacon + 15 * pasta + 23 * oranges + 18 * corn >= 70, "fat_total")


m.addConstr(9 * pasta - 4 * corn >= 0, "pasta_corn_ratio")
m.addConstr(4 * bacon - 4 * corn >= 0, "bacon_corn_ratio")

m.addConstr(25 * bacon + 25 * pasta + 5 * oranges <= 302, "iron_limit1")
m.addConstr(25 * bacon + 25 * pasta + 13 * corn <= 306, "iron_limit2")

m.addConstr(22 * bacon + 23 * oranges <= 124, "fat_limit1")
m.addConstr(22 * bacon + 15 * pasta <= 241, "fat_limit2")
m.addConstr(23 * oranges + 18 * corn <= 151, "fat_limit3")
m.addConstr(15 * pasta + 18 * corn <= 212, "fat_limit4")
m.addConstr(15 * pasta + 23 * oranges <= 279, "fat_limit5")
m.addConstr(15 * pasta + 23 * oranges + 18 * corn <= 172, "fat_limit6")
m.addConstr(22 * bacon + 15 * pasta + 18 * corn <= 139, "fat_limit7")


m.addConstr(25 * bacon + 22 * bacon <= 314, "resource0")
m.addConstr(15 * pasta + 23 * oranges <= 281, "resource1")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

