
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # strips of bacon
    x1 = model.addVar(name="x1", lb=0)  # bowls of pasta
    x2 = model.addVar(name="x2", lb=0)  # oranges
    x3 = model.addVar(name="x3", lb=0)  # corn cobs

    # Objective function
    model.setObjective(4.79 * x0 + 6.54 * x1 + 7.91 * x2 + 1.18 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(25 * x0 + 25 * x1 + 5 * x2 + 13 * x3 <= 314)
    model.addConstr(22 * x0 + 15 * x1 + 23 * x2 + 18 * x3 <= 281)
    model.addConstr(25 * x0 + 25 * x1 >= 42)
    model.addConstr(5 * x2 + 13 * x3 >= 54)
    model.addConstr(25 * x1 + 13 * x3 >= 46)
    model.addConstr(25 * x0 + 13 * x3 >= 72)
    model.addConstr(25 * x0 + 25 * x1 + 5 * x2 + 13 * x3 >= 72)
    model.addConstr(22 * x0 + 15 * x1 >= 45)
    model.addConstr(22 * x0 + 23 * x2 >= 26)
    model.addConstr(15 * x1 + 18 * x3 >= 36)
    model.addConstr(15 * x1 + 23 * x2 >= 34)
    model.addConstr(22 * x0 + 18 * x3 >= 57)
    model.addConstr(22 * x0 + 23 * x2 + 18 * x3 >= 48)
    model.addConstr(22 * x0 + 15 * x1 + 23 * x2 >= 48)
    model.addConstr(15 * x1 + 23 * x2 + 18 * x3 >= 48)
    model.addConstr(22 * x0 + 23 * x2 + 18 * x3 >= 66)
    model.addConstr(22 * x0 + 15 * x1 + 23 * x2 >= 66)
    model.addConstr(15 * x1 + 23 * x2 + 18 * x3 >= 66)
    model.addConstr(22 * x0 + 23 * x2 + 18 * x3 >= 70)
    model.addConstr(22 * x0 + 15 * x1 + 23 * x2 >= 70)
    model.addConstr(15 * x1 + 23 * x2 + 18 * x3 >= 70)
    model.addConstr(22 * x0 + 15 * x1 + 23 * x2 + 18 * x3 >= 70)
    model.addConstr(9 * x1 - 4 * x3 >= 0)
    model.addConstr(4 * x0 - 4 * x3 >= 0)
    model.addConstr(25 * x0 + 25 * x1 + 5 * x2 <= 302)
    model.addConstr(25 * x0 + 25 * x1 + 13 * x3 <= 306)
    model.addConstr(22 * x0 + 23 * x2 <= 124)
    model.addConstr(22 * x0 + 15 * x1 <= 241)
    model.addConstr(23 * x2 + 18 * x3 <= 151)
    model.addConstr(15 * x1 + 18 * x3 <= 212)
    model.addConstr(15 * x1 + 23 * x2 <= 279)
    model.addConstr(15 * x1 + 23 * x2 + 18 * x3 <= 172)
    model.addConstr(22 * x0 + 15 * x1 + 18 * x3 <= 139)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
