
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams of potassium")
x2 = m.addVar(lb=-gp.GRB.INFINITY, name="grams of protein")
x3 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams of vitamin D")
x4 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams of vitamin B12")
x5 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams of calcium")

# Objective function
m.setObjective(7.11*x1 + 6.69*x2 + 9.02*x3 + 1.68*x4 + 1.57*x5, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(2*x1 <= 182)
m.addConstr(5*x2 <= 182)
m.addConstr(4*x3 <= 182)
m.addConstr(4*x4 <= 182)
m.addConstr(7*x5 <= 182)

m.addConstr(2*x1 + 4*x3 >= 23)
m.addConstr(2*x1 + 7*x5 >= 35)
m.addConstr(5*x2 + 7*x5 >= 12)
m.addConstr(2*x1 + 5*x2 >= 21)
m.addConstr(4*x3 + 7*x5 >= 28)
m.addConstr(4*x4 + 7*x5 >= 16)
m.addConstr(2*x1 + 4*x4 >= 18)
m.addConstr(4*x3 + 4*x4 >= 25)
m.addConstr(2*x1 + 4*x3 + 4*x4 >= 35)
m.addConstr(2*x1 + 5*x2 + 4*x4 >= 35)
m.addConstr(4*x3 + 4*x4 + 7*x5 >= 35)
m.addConstr(5*x2 + 4*x3 + 4*x4 >= 35)
m.addConstr(2*x1 + 4*x3 + 7*x5 >= 35)
m.addConstr(2*x1 + 4*x4 + 7*x5 >= 35)

m.addConstr(2*x1 + 4*x3 + 4*x4 >= 32)
m.addConstr(2*x1 + 5*x2 + 4*x4 >= 32)
m.addConstr(4*x3 + 4*x4 + 7*x5 >= 32)
m.addConstr(5*x2 + 4*x3 + 4*x4 >= 32)
m.addConstr(2*x1 + 4*x3 + 7*x5 >= 32)
m.addConstr(2*x1 + 4*x4 + 7*x5 >= 32)

m.addConstr(2*x1 + 4*x3 + 4*x4 >= 24)
m.addConstr(2*x1 + 5*x2 + 4*x4 >= 24)
m.addConstr(4*x3 + 4*x4 + 7*x5 >= 24)
m.addConstr(5*x2 + 4*x3 + 4*x4 >= 24)
m.addConstr(2*x1 + 4*x3 + 7*x5 >= 24)
m.addConstr(2*x1 + 4*x4 + 7*x5 >= 24)

m.addConstr(2*x1 + 5*x2 + 4*x3 + 4*x4 + 7*x5 >= 24)

m.addConstr(-2*x1 + 10*x4 >= 0)
m.addConstr(4*x2 - 3*x3 >= 0)

m.addConstr(2*x1 + 4*x3 <= 72)
m.addConstr(5*x2 + 4*x4 <= 79)
m.addConstr(4*x3 + 4*x4 <= 124)
m.addConstr(2*x1 + 7*x5 <= 78)
m.addConstr(5*x2 + 4*x3 <= 130)
m.addConstr(2*x1 + 4*x4 <= 140)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of potassium: ", x1.varValue)
    print("Grams of protein: ", x2.varValue)
    print("Milligrams of vitamin D: ", x3.varValue)
    print("Milligrams of vitamin B12: ", x4.varValue)
    print("Milligrams of calcium: ", x5.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
