
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="cafeteria_chairs")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="office_chairs")

    # Set objective function
    m.setObjective(5.69 * x0 + 1.68 * x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(18.72 * x0 + 22.68 * x1 >= 40, "c0")
    m.addConstr(4.65 * x0 + 0.75 * x1 >= 131, "c1")
    m.addConstr(3.38 * x0 + 13.07 * x1 >= 31, "c2")
    m.addConstr(12.35 * x0 + 3.1 * x1 >= 44, "c3")
    m.addConstr(25.61 * x0 + 20.04 * x1 >= 97, "c4")
    m.addConstr(-8 * x0 + 9 * x1 >= 0, "c5")
    m.addConstr(18.72 * x0 + 22.68 * x1 <= 142, "c6")
    m.addConstr(4.65 * x0 + 0.75 * x1 <= 236, "c7")
    m.addConstr(3.38 * x0 + 13.07 * x1 <= 59, "c8")
    m.addConstr(12.35 * x0 + 3.1 * x1 <= 198, "c9")
    m.addConstr(25.61 * x0 + 20.04 * x1 <= 228, "c10")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('cafeteria_chairs:', x0.x)
        print('office_chairs:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
