
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="cafeteria_chairs", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="office_chairs", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(5.69 * x1 + 1.68 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(18.72 * x1 + 22.68 * x2 >= 40, name="workplace_safety_impact")
    model.addConstr(4.65 * x1 + 0.75 * x2 >= 131, name="weight")
    model.addConstr(3.38 * x1 + 13.07 * x2 >= 31, name="usefulness_rating")
    model.addConstr(12.35 * x1 + 3.1 * x2 >= 44, name="storage_space")
    model.addConstr(25.61 * x1 + 20.04 * x2 >= 97, name="dollar_cost")
    model.addConstr(-8 * x1 + 9 * x2 >= 0, name="linear_constraint")

    model.addConstr(18.72 * x1 + 22.68 * x2 <= 142, name="workplace_safety_impact_upper")
    model.addConstr(4.65 * x1 + 0.75 * x2 <= 236, name="weight_upper")
    model.addConstr(3.38 * x1 + 13.07 * x2 <= 59, name="usefulness_rating_upper")
    model.addConstr(12.35 * x1 + 3.1 * x2 <= 198, name="storage_space_upper")
    model.addConstr(25.61 * x1 + 20.04 * x2 <= 228, name="dollar_cost_upper")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cafeteria chairs: {x1.varValue}")
        print(f"Office chairs: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
