
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_pasta")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")


    # Set objective function
    m.setObjective(9*x0 + 4*x1 + 2*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3.46*x1 + 4.79*x2 >= 20, "c0")
    m.addConstr(5.02*x0 + 4.79*x2 >= 23, "c1")
    m.addConstr(5.02*x0 + 3.46*x1 + 4.79*x2 >= 51, "c2")
    m.addConstr(5.02*x0 + 3.46*x1 <= 144, "c3")
    m.addConstr(3.46*x1 + 4.79*x2 <= 83, "c4")
    m.addConstr(5.02*x0 + 3.46*x1 + 4.79*x2 <= 83, "c5")
    m.addConstr(1.76*x0 + 2.08*x1 <= 42, "c6")
    m.addConstr(2.08*x1 + 1.73*x2 <= 41, "c7")
    m.addConstr(1.76*x0 + 2.08*x1 + 1.73*x2 <= 46, "c8")
    m.addConstr(1.76*x0 + 2.08*x1 + 1.73*x2 <= 46, "c9")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
