
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="bowls_of_pasta", lb=0)  # bowls of pasta
    x1 = model.addVar(name="corn_cobs", lb=0)    # corn cobs
    x2 = model.addVar(name="lemons", lb=0)      # lemons

    # Objective function
    model.setObjective(9 * x0 + 4 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3.46 * x1 + 4.79 * x2 >= 20)  # At least 20 milligrams of calcium from corn cobs and lemons
    model.addConstr(5.02 * x0 + 4.79 * x2 >= 23)  # At least 23 milligrams of calcium from bowls of pasta and lemons
    model.addConstr(5.02 * x0 + 3.46 * x1 + 4.79 * x2 >= 51)  # At least 51 milligrams of calcium from all
    model.addConstr(5.02 * x0 + 3.46 * x1 <= 144)  # At most 144 milligrams of calcium from bowls of pasta and corn cobs
    model.addConstr(3.46 * x1 + 4.79 * x2 <= 83)  # At most 83 milligrams of calcium from corn cobs and lemons
    # model.addConstr(5.02 * x0 + 3.46 * x1 + 4.79 * x2 <= 83)  # This constraint is redundant
    model.addConstr(1.76 * x0 + 2.08 * x1 <= 42)  # Healthiness rating from bowls of pasta and corn cobs
    model.addConstr(2.08 * x1 + 1.73 * x2 <= 41)  # Healthiness rating from corn cobs and lemons
    model.addConstr(1.76 * x0 + 2.08 * x1 + 1.73 * x2 <= 46)  # Total healthiness rating

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("bowls of pasta: ", x0.varValue)
        print("corn cobs: ", x1.varValue)
        print("lemons: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
