
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B3
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of potassium


    # Set objective function
    m.setObjective(1.47 * x0 + 4.67 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2 * x0 + 3 * x1 >= 16, "c0")
    m.addConstr(16 * x0 + 21 * x1 >= 24, "c1")
    m.addConstr(-10 * x0 + 3 * x1 >= 0, "c2")
    m.addConstr(2 * x0 + 3 * x1 <= 57, "c3")
    m.addConstr(16 * x0 + 21 * x1 <= 64, "c4")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
