
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="milligrams_of_vitamin_B3", lb=0)  # No lower bound specified, assuming 0
x2 = model.addVar(name="milligrams_of_potassium", lb=0)  # No lower bound specified, assuming 0

# Define the objective function
model.setObjective(1.47 * x1 + 4.67 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * x1 + 3 * x2 >= 16, name="muscle_growth_index_min")
model.addConstr(16 * x1 + 21 * x2 >= 24, name="cardiovascular_support_index_min")
model.addConstr(-10 * x1 + 3 * x2 >= 0, name="vitamin_potassium_balance")
model.addConstr(2 * x1 + 3 * x2 <= 57, name="muscle_growth_index_max")
model.addConstr(16 * x1 + 21 * x2 <= 64, name="cardiovascular_support_index_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B3: {x1.varValue}")
    print(f"Milligrams of potassium: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
