
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin B7
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # grams of fat


    # Set objective function
    m.setObjective(2*x0**2 + 3*x0, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(32*x0 + 10*x1 >= 21, "c0")
    m.addConstr(19*x0 + 32*x1 >= 70, "c1")
    m.addConstr(7*x0 - 4*x1 >= 0, "c2")
    m.addConstr(32*x0 + 10*x1 <= 42, "c3")
    m.addConstr(19*x0 + 32*x1 <= 134, "c4")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

