
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B7")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="grams_of_fat")

# Set the objective function
m.setObjective(2*x1**2 + 3*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(32*x1 + 10*x2 >= 21, "total_energy_stability_index_min")
m.addConstr(19*x1 + 32*x2 >= 70, "total_muscle_growth_index_min")
m.addConstr(7*x1 - 4*x2 >= 0, "vitamin_B7_and_fat_constraint")
m.addConstr(32*x1 + 10*x2 <= 42, "total_energy_stability_index_max")
m.addConstr(19*x1 + 32*x2 <= 134, "total_muscle_growth_index_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B7: {x1.x}")
    print(f"Grams of Fat: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
