
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_vitamin_B7", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="grams_of_fat", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(2*x1**2 + 3*x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(32*x1 + 10*x2 >= 21, name="energy_stability_index_min")
    model.addConstr(19*x1 + 32*x2 >= 70, name="muscle_growth_index_min")
    model.addConstr(7*x1 - 4*x2 >= 0, name="interaction_constraint")
    model.addConstr(32*x1 + 10*x2 <= 42, name="energy_stability_index_max")
    model.addConstr(19*x1 + 32*x2 <= 134, name="muscle_growth_index_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B7: {x1.varValue}")
        print(f"Grams of fat: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
