
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
zinc = m.addVar(vtype=gp.GRB.INTEGER, name="zinc")
calcium = m.addVar(vtype=gp.GRB.CONTINUOUS, name="calcium")
vitamin_b2 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b2")
vitamin_k = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_k")


# Set objective function
m.setObjective(5*zinc + 3*calcium + 5*vitamin_b2 + 7*vitamin_k, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*zinc + 7*vitamin_b2 + 11*vitamin_k >= 19)
m.addConstr(7*zinc + 9*calcium + 11*vitamin_k >= 19)
m.addConstr(7*zinc + 9*calcium + 7*vitamin_b2 >= 19)

m.addConstr(7*zinc + 11*vitamin_k <= 77)
m.addConstr(7*zinc + 9*calcium <= 54)
m.addConstr(7*zinc + 7*vitamin_b2 <= 60)
m.addConstr(7*zinc + 7*vitamin_b2 + 11*vitamin_k <= 88)
m.addConstr(7*zinc + 9*calcium + 7*vitamin_b2 <= 39)
m.addConstr(7*zinc + 9*calcium + 7*vitamin_b2 + 11*vitamin_k <= 39)


m.addConstr(8*zinc + 1*calcium <= 48)
m.addConstr(10*vitamin_b2 + 5*vitamin_k <= 53)
m.addConstr(8*zinc + 1*calcium + 10*vitamin_b2 + 5*vitamin_k <= 53)

m.addConstr(8*zinc + 1*calcium + 10*vitamin_b2 >= 10)
m.addConstr(8*zinc + 10*vitamin_b2 + 5*vitamin_k >= 10)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('zinc:', zinc.x)
    print('calcium:', calcium.x)
    print('vitamin_b2:', vitamin_b2.x)
    print('vitamin_k:', vitamin_k.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

