
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="x0", lb=0, Integrality=1)  # milligrams of zinc
x1 = m.addVar(name="x1", lb=0)  # milligrams of calcium
x2 = m.addVar(name="x2", lb=0, Integrality=1)  # milligrams of vitamin B2
x3 = m.addVar(name="x3", lb=0, Integrality=1)  # milligrams of vitamin K

# Objective function
m.setObjective(5 * x0 + 3 * x1 + 5 * x2 + 7 * x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(7 * x0 <= 93)
m.addConstr(8 * x0 <= 63)
m.addConstr(9 * x1 <= 93)
m.addConstr(1 * x1 <= 63)
m.addConstr(7 * x2 <= 93)
m.addConstr(10 * x2 <= 63)
m.addConstr(11 * x3 <= 93)
m.addConstr(5 * x3 <= 63)
m.addConstr(7 * x0 + 7 * x2 + 11 * x3 >= 19)
m.addConstr(7 * x0 + 9 * x1 + 11 * x3 >= 19)
m.addConstr(7 * x0 + 9 * x1 + 7 * x2 >= 19)
m.addConstr(7 * x0 + 7 * x2 + 11 * x3 >= 15)
m.addConstr(7 * x0 + 9 * x1 + 11 * x3 >= 15)
m.addConstr(7 * x0 + 9 * x1 + 7 * x2 >= 15)
m.addConstr(7 * x0 + 7 * x2 + 11 * x3 >= 14)
m.addConstr(7 * x0 + 9 * x1 + 11 * x3 >= 14)
m.addConstr(7 * x0 + 9 * x1 + 7 * x2 >= 14)
m.addConstr(8 * x0 + 1 * x1 + 10 * x2 >= 10)
m.addConstr(8 * x0 + 10 * x2 + 5 * x3 >= 10)
m.addConstr(8 * x0 + 1 * x1 + 10 * x2 >= 10)
m.addConstr(8 * x0 + 10 * x2 + 5 * x3 >= 10)
m.addConstr(7 * x0 + 11 * x3 <= 77)
m.addConstr(7 * x0 + 9 * x1 <= 54)
m.addConstr(7 * x0 + 7 * x2 <= 60)
m.addConstr(7 * x0 + 7 * x2 + 11 * x3 <= 88)
m.addConstr(7 * x0 + 9 * x1 + 7 * x2 <= 39)
m.addConstr(7 * x0 + 9 * x1 + 7 * x2 + 11 * x3 <= 39)
m.addConstr(8 * x0 + 1 * x1 <= 48)
m.addConstr(10 * x2 + 5 * x3 <= 53)
m.addConstr(8 * x0 + 1 * x1 + 10 * x2 + 5 * x3 <= 53)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
