
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x = model.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, name=["George", "Bill", "Hank", "Jean"])

    # Set objective function
    model.setObjective(4*x[0] + 9*x[1] + 5*x[2] + 3*x[3], gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5*x[1] + 5*x[3] >= 18)
    model.addConstr(8*x[2] + 5*x[3] >= 19)
    model.addConstr(5*x[0] + 8*x[2] >= 15)
    model.addConstr(5*x[0] + 8*x[2] + 5*x[3] >= 17)
    model.addConstr(8*x[1] + 8*x[2] + 5*x[3] >= 17)
    model.addConstr(5*x[0] + 8*x[2] + 5*x[3] >= 19)
    model.addConstr(8*x[1] + 8*x[2] + 5*x[3] >= 19)
    model.addConstr(5*x[0] + 8*x[1] + 8*x[2] + 5*x[3] >= 19)
    model.addConstr(8*x[0] - 2*x[1] >= 0)
    model.addConstr(-3*x[0] + x[2] >= 0)
    model.addConstr(-x[1] + 7*x[3] >= 0)
    model.addConstr(5*x[0] + 8*x[1] <= 77)
    model.addConstr(8*x[1] + 8*x[2] <= 55)
    model.addConstr(5*x[0] + 8*x[2] <= 64)
    model.addConstr(8*x[1] + 8*x[2] + 5*x[3] <= 53)
    model.addConstr(5*x[0] + 8*x[1] + 8*x[2] <= 67)
    model.addConstr(5*x[0] + 8*x[1] + 5*x[3] <= 44)
    model.addConstr(5*x[0] + 8*x[2] + 5*x[3] <= 35)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        for v in model.getVars():
            print(f"{v.varName}: {v.x}")
        print(f"Obj: {model.objVal}")
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
