
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_George", lb=0)
x2 = m.addVar(name="hours_worked_by_Bill", lb=0)
x3 = m.addVar(name="hours_worked_by_Hank", lb=0)
x4 = m.addVar(name="hours_worked_by_Jean", lb=0)

# Objective function
m.setObjective(4*x1 + 9*x2 + 5*x3 + 3*x4, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(5*x1 == 5)
m.addConstr(8*x2 == 8)
m.addConstr(8*x3 == 8)
m.addConstr(5*x4 == 5)

m.addConstr(8*x2 + 5*x4 >= 18)
m.addConstr(8*x3 + 5*x4 >= 19)
m.addConstr(5*x1 + 8*x3 >= 15)
m.addConstr(5*x1 + 8*x3 + 5*x4 >= 17)
m.addConstr(8*x2 + 8*x3 + 5*x4 >= 17)
m.addConstr(5*x1 + 8*x3 + 5*x4 >= 19)
m.addConstr(8*x2 + 8*x3 + 5*x4 >= 19)
m.addConstr(5*x1 + 8*x2 + 8*x3 + 5*x4 >= 19)

m.addConstr(8*x1 - 2*x2 >= 0)
m.addConstr(-3*x1 + x3 >= 0)
m.addConstr(-x2 + 7*x4 >= 0)

m.addConstr(5*x1 + 8*x2 <= 77)
m.addConstr(8*x2 + 8*x3 <= 55)
m.addConstr(5*x1 + 8*x3 <= 64)
m.addConstr(8*x2 + 8*x3 + 5*x4 <= 53)
m.addConstr(5*x1 + 8*x2 + 8*x3 <= 67)
m.addConstr(5*x1 + 8*x2 + 5*x4 <= 44)
m.addConstr(5*x1 + 8*x3 + 5*x4 <= 35)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by George: ", x1.varValue)
    print("Hours worked by Bill: ", x2.varValue)
    print("Hours worked by Hank: ", x3.varValue)
    print("Hours worked by Jean: ", x4.varValue)
else:
    print("The model is infeasible")
