
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")


# Set objective function
model.setObjective(7 * hank + 1 * mary + 6 * george + 8 * dale, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10 * hank + 7 * mary + 12 * george + 8 * dale <= 174, "r0")
model.addConstr(7 * hank + 13 * mary + 13 * george + 6 * dale <= 170, "r1")
model.addConstr(7 * mary + 12 * george >= 29, "c1")
model.addConstr(7 * hank + 6 * dale >= 17, "c2")
model.addConstr(13 * mary + 6 * dale >= 14, "c3")
model.addConstr(7 * hank + 13 * george >= 15, "c4")
model.addConstr(13 * mary + 13 * george >= 38, "c5")
model.addConstr(7 * hank + 13 * mary + 6 * dale >= 40, "c6")
model.addConstr(7 * hank + 13 * mary + 13 * george >= 40, "c7")
model.addConstr(13 * mary + 13 * george + 6 * dale >= 40, "c8")
model.addConstr(7 * hank + 13 * mary + 6 * dale >= 35, "c9")
model.addConstr(7 * hank + 13 * mary + 13 * george >= 35, "c10")
model.addConstr(13 * mary + 13 * george + 6 * dale >= 35, "c11")
model.addConstr(7 * hank + 13 * mary + 6 * dale >= 21, "c12")
model.addConstr(7 * hank + 13 * mary + 13 * george >= 21, "c13")
model.addConstr(13 * mary + 13 * george + 6 * dale >= 21, "c14")
model.addConstr(10 * hank + 7 * mary <= 155, "c15")
model.addConstr(12 * george + 8 * dale <= 153, "c16")
model.addConstr(10 * hank + 8 * dale <= 157, "c17")
model.addConstr(7 * mary + 12 * george <= 78, "c18")
model.addConstr(7 * mary + 8 * dale <= 69, "c19")
model.addConstr(10 * hank + 7 * mary + 12 * george + 8 * dale <= 69, "c20")
model.addConstr(13 * mary + 13 * george <= 93, "c21")
model.addConstr(7 * hank + 13 * george <= 99, "c22")
model.addConstr(7 * hank + 13 * mary + 6 * dale <= 89, "c23")
model.addConstr(7 * hank + 13 * mary + 13 * george + 6 * dale <= 89, "c24")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hank: {hank.x}")
    print(f"Mary: {mary.x}")
    print(f"George: {george.x}")
    print(f"Dale: {dale.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

