
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Hank
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Mary
    x2 = model.addVar(name="x2", lb=0)  # hours worked by George
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Dale

    # Objective function
    model.setObjective(7*x0 + x1 + 6*x2 + 8*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7*x1 + 12*x2 >= 29)
    model.addConstr(7*x0 + 6*x3 >= 17)
    model.addConstr(13*x1 + 6*x3 >= 14)
    model.addConstr(7*x0 + 13*x2 >= 15)
    model.addConstr(13*x1 + 13*x2 >= 38)
    model.addConstr(7*x0 + 13*x1 + 6*x3 >= 40)
    model.addConstr(7*x0 + 13*x1 + 13*x2 >= 40)
    model.addConstr(13*x1 + 13*x2 + 6*x3 >= 40)
    model.addConstr(7*x0 + 13*x1 + 6*x3 >= 35)
    model.addConstr(7*x0 + 13*x1 + 13*x2 >= 35)
    model.addConstr(13*x1 + 13*x2 + 6*x3 >= 35)
    model.addConstr(13*x1 + 6*x3 >= 21)
    model.addConstr(7*x0 + 13*x1 + 13*x2 >= 21)
    model.addConstr(13*x1 + 13*x2 + 6*x3 >= 21)
    model.addConstr(10*x0 + 7*x1 <= 155)
    model.addConstr(12*x2 + 8*x3 <= 153)
    model.addConstr(10*x0 + 8*x3 <= 157)
    model.addConstr(7*x1 + 12*x2 <= 78)
    model.addConstr(7*x1 + 8*x3 <= 69)
    model.addConstr(10*x0 + 7*x1 + 12*x2 + 8*x3 <= 69)
    model.addConstr(13*x1 + 13*x2 <= 93)
    model.addConstr(7*x0 + 13*x2 <= 99)
    model.addConstr(7*x0 + 13*x1 + 6*x3 <= 89)
    model.addConstr(7*x0 + 13*x1 + 13*x2 + 6*x3 <= 89)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Hank: ", x0.varValue)
        print("Hours worked by Mary: ", x1.varValue)
        print("Hours worked by George: ", x2.varValue)
        print("Hours worked by Dale: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
